unit UserApp03Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, Grids, ComCtrls,
  UserApp03Data, Service01, Cargo01, Loading01, AirCraft01;

type
  TUserApp03Form = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Label3: TLabel;
    sttxtLZW: TStaticText;
    Label4: TLabel;
    Label5: TLabel;
    StaticText1: TStaticText;
    Label10: TLabel;
    Label11: TLabel;
    stxtPitch: TStaticText;
    stxtRoll: TStaticText;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    //procedure CbBoxCargoBaseClick(Sender: TObject);
    //procedure edCargoWeightChange(Sender: TObject);
    //procedure TrackBarPitchChange(Sender: TObject);
    //procedure TrackBarRollChange(Sender: TObject);
   // procedure edCargoZCChange(Sender: TObject);
  private
    procedure ShowCargoWeight (Sended : TObject);
    procedure ShowPitchAndRoll(Sended : TObject);
  public

  end;

var
  UserApp03Form: TUserApp03Form;

// -------------------------------------------------------------------------
var Loading  : TLoading;

// ========================================================================
// ========================================================================

implementation
{$R *.dfm}

// ========================================================================
// ========================================================================

// ========================================================================
//    
// ========================================================================
// -------------------------------------------------------------------------
//    
function GetApplicationDirectory() : string;
begin
   Result := Application.ExeName;
   Result := ExtractFileDir(Result);
end;
// -------------------------------------------------------------------------
procedure TUserApp03Form.FormCreate(Sender: TObject);
begin
   //    
   AirCraftRec := AirCraftRecAn70;
   //   
   if not Assigned(Loading)
   then begin
      Loading := TLoading.Create(Panel1, 10,10,
                                 Panel1.Width  - 20,
                                 Panel1.Height - 20 );
      Loading.onWLChange    := ShowCargoWeight;
      Loading.onAngleChange := ShowPitchAndRoll;
   end;
end;
// -------------------------------------------------------------------------
procedure TUserApp03Form.FormDestroy(Sender: TObject);
begin
  if Assigned(Loading)
  then begin
     Loading.Free;
     Loading := nil;
  end;
end;
// -------------------------------------------------------------------------
//   -    
procedure TUserApp03Form.ShowCargoWeight(Sended : TObject);
begin
  if Assigned(Loading)
  then begin
   sttxtLZW.Caption := FloatToStr(Loading.WSumCargo);
  end;
end;
// -------------------------------------------------------------------------
//   -    
procedure TUserApp03Form.ShowPitchAndRoll(Sended : TObject);
const ToDeg = 180 / Pi;
begin
  if Assigned(Loading)
  then begin
     stxtPitch.Caption := FloatToStr(Loading.PitchAngle * ToDeg);
     stxtRoll.Caption  := FloatToStr(Loading.RollAngle  * ToDeg);
  end;
end;
// ========================================================================
//  
// ========================================================================

end.
